#include "ConstantBuffers.hlsli"

float4 main( PS_INPUT input) : SV_TARGET
{
    float4 colorTex = txDiffuse.Sample( samLinear, input.Tex);

    const float ratioThreasHold = 0.1;
    const float ratioThreasHoldsup = 1- ratioThreasHold;

    if(SequenceRatio <= ratioThreasHold)
    {
        return lerp(colorFlash, colorTex,  SequenceRatio / ratioThreasHold);
    }
    else if (SequenceRatio >= ratioThreasHoldsup)
    {
        return lerp(colorTex, colorFlash,  (SequenceRatio - ratioThreasHoldsup) / ratioThreasHold);
    }
    else
    {
        return colorTex;
    }
}